<?php
if( is_admin() ) {

	/* Start of: WordPress Administration */

	function wpsc_wp_check_options_exist() {

		$sample = get_option( 'vl_wpscwp_defaults' );
		if( $sample )
			return true;

	}

	function wpsc_wp_template_header() {

		global $wpsc_wp; ?>
<div id="profile-page" class="wrap">
	<div id="icon-options-general" class="icon32"><br /></div>
	<h2><?php echo $wpsc_wp['menu']; ?></h2>
<?php
	}

	function wpsc_wp_template_footer() { ?>
</div>
<?php
	}

	/* Product Importer Deluxe: http://www.visser.com.au/plugins/product-importer-deluxe/ */
	function wpsc_wp_pd_options_addons( $options ) {

		$roles = wpsc_wp_get_roles();
		if( $roles ) {
			foreach( $roles as $key => $role )
				$options[] = array( 'wholesale_' . $key, __( 'Wholesale Pricing', 'wpsc_wp' ) . ' - ' . $role['name'] );
		}
		return $options;

	}
	add_filter( 'wpsc_pd_options_addons', 'wpsc_wp_pd_options_addons', null, 1 );

	function wpsc_wp_pd_import_addons( $import, $csv_data ) {

		$import->roles = wpsc_wp_get_roles();
		if( $import->roles ) {
			$import->csv_wholesale = array();
			foreach( $import->roles as $key => $role ) {
				if( isset( $csv_data['wholesale_' . $key ] ) ) {
					$import->csv_wholesale_price[$key] = $csv_data['wholesale_' . $key ];
					$import->log .= "<br />>>> " . __( 'Wholesale Pricing has been detected: ', 'wpsc_pd' ) . $role['name'];
				}
			}
		}
		return $import;

	}
	add_filter( 'wpsc_pd_import_addons', 'wpsc_wp_pd_import_addons', null, 2 );

	/* Product Importer Deluxe - Import integration */
	function wpsc_wp_pd_product_addons( $product, $import, $count ) {

		if( isset( $import->roles ) && function_exists( 'wpsc_wp_insert_wholesale_price' ) ) {
			$product->wholesale_price = array();
			foreach( $import->roles as $key => $role ) {
				if( isset( $import->csv_wholesale_price[$key][$count] ) )
					$product->wholesale_price[$key] = wpsc_wp_format_wholesale_price( $import->csv_wholesale_price[$key][$count] );
			}
		}
		return $product;

	}
	add_filter( 'wpsc_pd_product_addons', 'wpsc_wp_pd_product_addons', null, 3 );

	function wpsc_wp_pd_create_product_addons( $product, $import ) {

		if( isset( $import->roles ) && function_exists( 'wpsc_wp_insert_wholesale_price' ) ) {
			foreach( $import->roles as $key => $role ) {
				if( !empty( $product->wholesale_price[$key] ) )
					$product->product_meta = wpsc_wp_insert_wholesale_price( $product->ID, $key, $product->wholesale_price[$key], $product->product_meta );
			}
		}
		return $product;

	}
	add_filter( 'wpsc_pd_create_product_addons', 'wpsc_wp_pd_create_product_addons', null, 2 );

	function wpsc_wp_pd_create_product_log_addons( $import, $product ) {

		if( isset( $import->roles ) && function_exists( 'wpsc_wp_insert_wholesale_price' ) ) {
			$import->log .= "<br />>>>>>> " . __( 'Setting Wholesale Pricing', 'wpsc_pd' );
			if( isset( $import->advanced_log ) && $import->advanced_log ) {
				$args = array(
					'display_as_html' => false
				);
				foreach( $import->roles as $key => $role ) {
					if( !empty( $product->wholesale_price[$key] ) ) {
						if( $product->wholesale_price[$key] == '-' ) { // Detect disable
							$import->log .= "<br />>>>>>>>>> " . sprintf( __( '%s: Disable Wholesale Pricing for this Role', 'wpsc_pd' ), $role['name'] );
						} else {
							if( substr( $product->wholesale_price[$key], -1, 1 ) == '%' ) { // Detect percent mark-up/mark-down
								if( $product->wholesale_price[$key][0] == '-' )
									$import->log .= "<br />>>>>>>>>> " . sprintf( __( '%s: Mark down by %s', 'wpsc_pd' ), $role['name'], substr( $product->wholesale_price[$key], 1 ) );
								else if( $product->wholesale_price[$key][0] == '+' )
									$import->log .= "<br />>>>>>>>>> " . sprintf( __( '%s: Mark up by %s', 'wpsc_pd' ), $role['name'], substr( $product->wholesale_price[$key], 1 ) );
								else
									$import->log .= "<br />>>>>>>>>> " . sprintf( __( '%s: Mark up by %s', 'wpsc_pd' ), $role['name'], $product->wholesale_price[$key] );
							} else if( $product->wholesale_price[$key][0] == '-' || $product->wholesale_price[$key][0] == '+' ) { // Detect currency mark-up/mark-down
								if( $product->wholesale_price[$key][0] == '-' )
									$import->log .= "<br />>>>>>>>>> " . sprintf( __( '%s: Mark down by %s', 'wpsc_pd' ), $role['name'], wpsc_currency_display( substr( $product->wholesale_price[$key], 1 ), $args ) );
								else
									$import->log .= "<br />>>>>>>>>> " . sprintf( __( '%s: Mark up by %s', 'wpsc_pd' ), $role['name'], wpsc_currency_display( substr( $product->wholesale_price[$key], 1 ), $args ) );
							} else { // Detect fixed price
								$import->log .= "<br />>>>>>>>>> " . sprintf( __( '%s: Fixed price of %s', 'wpsc_pd' ), $role['name'], wpsc_currency_display( $product->wholesale_price[$key], $args ) );
							}
						}
					}
				}
			}
		} else if( isset( $import->advanced_log ) && $import->advanced_log ) {
			$import->log .= "<br />>>>>>> " . __( 'Skipping Wholesale Prices', 'wpsc_pd' );
		}
		return $import;

	}
	add_filter( 'wpsc_pd_create_product_log_addons', 'wpsc_wp_pd_create_product_log_addons', null, 2 );

	/* Product Importer Deluxe - Merge changes integration */
	function wpsc_wp_pd_merge_product_data_addons( $product_data, $product, $import ) {

		$post_data = $product_data->post_data;
		if( isset( $post_data->product_meta['wpsc_wp_checkbox'] ) )
			$product_data->wholesale_price_checkbox = $post_data->product_meta['wpsc_wp_checkbox'];
		if( isset( $post_data->product_meta['wpsc_wp_value'] ) )
			$product_data->wholesale_price_value = $post_data->product_meta['wpsc_wp_value'];
		if( isset( $post_data->product_meta['wpsc_wp_amount'] ) )
			$product_data->wholesale_price_amount = $post_data->product_meta['wpsc_wp_amount'];
		if( isset( $post_data->product_meta['wpsc_wp_method'] ) )
			$product_data->wholesale_price_method = $post_data->product_meta['wpsc_wp_method'];
		if( isset( $post_data->product_meta['wpsc_wp_fixed'] ) )
			$product_data->wholesale_price_fixed = $post_data->product_meta['wpsc_wp_fixed'];
		if( isset( $post_data->product_meta['wpsc_wp_visibility'] ) )
			$product_data->wholesale_price_visibility = $post_data->product_meta['wpsc_wp_visibility'];
		$product_data->wholesale_price = wpsc_wp_raw_wholesale_price( $product_data->wholesale_price_checkbox, $product_data->wholesale_price_value, $product_data->wholesale_price_amount, $product_data->wholesale_price_method, $product_data->wholesale_price_fixed );

		if( isset( $import->roles ) && function_exists( 'wpsc_wp_insert_wholesale_price' ) ) {
			foreach( $import->roles as $key => $role ) {
				if( !empty( $product->wholesale_price[$key] ) ) {
					if( $product_data->wholesale_price[$key] <> $product->wholesale_price[$key] ) {
						$product_data->product_meta['wpsc_wp_checkbox'][$key] = 'on';
						if( $product->wholesale_price[$key] == '-' ) { // Detect disable
							unset( $product_data->product_meta['wpsc_wp_checkbox'][$key] );
						} else if( substr( $product->wholesale_price[$key], -1, 1 ) == '%' ) { // Detect percent mark-up/mark-down
							$product_data->product_meta['wpsc_wp_method'][$key] = '%';
							$product_data->product_meta['wpsc_wp_value'][$key] = '+';
							if( $product->wholesale_price[$key][0] == '-' )
								$product_data->product_meta['wpsc_wp_value'][$key] = '-';
							$product_data->product_meta['wpsc_wp_amount'][$key] = (int)substr( $product->wholesale_price[$key], 1, -1 );
						} else if( $product->wholesale_price[$key][0] == '-' || $product->wholesale_price[$key][0] == '+' ) { // Detect currency mark-up/mark-down
							$product_data->product_meta['wpsc_wp_method'][$key] = '$';
							if( $product->wholesale_price[$key][0] == '-' )
								$product_data->product_meta['wpsc_wp_value'][$key] = '-';
							$product_data->product_meta['wpsc_wp_amount'][$key] = substr( $product->wholesale_price[$key], 1, -1 );
						} else { // Detect fixed price
							$product_data->product_meta['wpsc_wp_fixed'][$key] = $product->wholesale_price[$key];
						}
					}
				}
			}
		}
		return $product_data;

	}
	add_filter( 'wpsc_pd_merge_product_data_addons', 'wpsc_wp_pd_merge_product_data_addons', null, 3 );

	function wpsc_wp_pd_merge_product_log_addons( $import, $product, $product_data ) {

		if( isset( $import->roles ) && function_exists( 'wpsc_wp_insert_wholesale_price' ) ) {
			$import->log .= "<br />>>>>>> " . __( 'Updating Wholesale Pricing', 'wpsc_pd' );
			if( isset( $import->advanced_log ) && $import->advanced_log ) {
				$args = array(
					'display_as_html' => false
				);
				foreach( $import->roles as $key => $role ) {
					if( !empty( $product->wholesale_price[$key] ) ) {
						if( $product_data->wholesale_price[$key] == $product->wholesale_price[$key] ) {
							$import->log .= "<br />>>>>>>>>> " . sprintf( __( 'Skipping %s', 'wpsc_pd' ), $role['name'] );
						} else if( $product->wholesale_price[$key] == '-' ) { // Detect disable
							if( $product_data->wholesale_price[$key] == '-' && $product->wholesale_price[$key] == '-' )
								$import->log .= "<br />>>>>>>>>> " . sprintf( __( 'Skipping %s', 'wpsc_pd' ), $role['name'] );
							else
								$import->log .= "<br />>>>>>>>>> " . sprintf( __( 'Updating %s: %s to disabled', 'wpsc_pd' ), $role['name'], $product->wholesale_price[$key] );
						} else if( substr( $product->wholesale_price[$key], -1, 1 ) == '%' ) { // Detect percent mark-up/mark-down
								if( $product->wholesale_price[$key][0] == '-' )
									$import->log .= "<br />>>>>>>>>> " . sprintf( __( 'Updating %s: %s to Mark down by %s', 'wpsc_pd' ), $role['name'], $product_data->wholesale_price[$key], substr( $product->wholesale_price[$key], 1 ) );
								else if( $product->wholesale_price[$key][0] == '+' )
									$import->log .= "<br />>>>>>>>>> " . sprintf( __( 'Updating %s: %s to Mark up by %s', 'wpsc_pd' ), $role['name'], $product_data->wholesale_price[$key], substr( $product->wholesale_price[$key], 1 ) );
								else
									$import->log .= "<br />>>>>>>>>> " . sprintf( __( 'Updating %s: %s to Mark up by %s', 'wpsc_pd' ), $role['name'], $product_data->wholesale_price[$key], $product->wholesale_price[$key] );
						} else if( $product->wholesale_price[$key][0] == '-' || $product->wholesale_price[$key][0] == '+' ) { // Detect currency mark-up/mark-down
							if( $product->wholesale_price[$key][0] == '-' )
								$import->log .= "<br />>>>>>>>>> " . sprintf( __( '%s: %s to Mark down by %s', 'wpsc_pd' ), $role['name'], $product_data->wholesale_price[$key], wpsc_currency_display( substr( $product->wholesale_price[$key], 1 ), $args ) );
							else
								$import->log .= "<br />>>>>>>>>> " . sprintf( __( '%s: %s to Mark up by %s', 'wpsc_pd' ), $role['name'], $product_data->wholesale_price[$key], wpsc_currency_display( substr( $product->wholesale_price[$key], 1 ), $args ) );
						} else { // Detect fixed price
							$import->log .= "<br />>>>>>>>>> " . sprintf( __( 'Updating %s: %s to Fixed price of %s', 'wpsc_pd' ), $role['name'], wpsc_currency_display( $product_data->wholesale_price[$key], $args ), wpsc_currency_display( $product->wholesale_price[$key], $args ) );
						}
					}
				}
			}
		} else if( isset( $import->advanced_log ) && $import->advanced_log ) {
			$import->log .= "<br />>>>>>> " . __( 'Skipping Wholesale Prices', 'wpsc_pd' );
		}
		return $import;

	}
	add_filter( 'wpsc_pd_merge_product_log_addons', 'wpsc_wp_pd_merge_product_log_addons', null, 3 );

	function wpsc_wp_format_wholesale_price( $wholesale_price = '' ) {

		if( substr( $wholesale_price, -1, 1 ) == '%' ) { // Detect percent mark-up/mark-down

			if( !in_array( $wholesale_price[0], array( '-', '+' ) ) ) // Detect missing '+' (positive) character
				$wholesale_price = '+' . $wholesale_price;

		}
		return $wholesale_price;

	}

	function wpsc_wp_raw_wholesale_price( $checkbox, $value, $amount, $method, $fixed ) {

		$wholesale_price = array();
		$roles = wpsc_wp_get_roles();
		if( $roles ) {
			$args = array(
				'display_currency_symbol' => false,
				'display_as_html' => false
			);
			foreach( $roles as $key => $role ) {
				$wholesale_price[$key] = '';
				if( !isset( $checkbox[$key] ) || ( isset( $checkbox[$key] ) && $checkbox[$key] == 'off' ) ) {
					$wholesale_price[$key] = '-';
				} else if( isset( $fixed[$key] ) && ( $fixed[$key] > 0 ) ) {
					$wholesale_price[$key] = wpsc_currency_display( $fixed[$key], $args );
				} else {
					if( isset( $method[$key] ) && ( $method[$key] == '%' ) )
						$wholesale_price[$key] = $value[$key] . $amount[$key] . '%';
					else
						$wholesale_price[$key] = $value[$key] . wpsc_currency_display( $amount[$key], $args );
				}
			}
		}
		return $wholesale_price;

	}

	/* End of: WordPress Administration */

} else {

	/* Start of: Storefront */

	function wpsc_wp_exclude_sales_tax() {

		//global $wpsc_cart;

		return 0;
/*
		foreach( $wpsc_cart as $key => $cart_item ) {
			if( is_array( $cart_item ) ) {
				foreach( $cart_item as $array_key => $array_item ) {
					//echo '<br />' . $array_key . ': ' . print_r( $array_item, true );
					echo '<br />' . $array_key . ': ';
					foreach( $array_item as $object_key => $object_item ) {
						echo '<br />' . $object_key . ': ' . $object_item;
					}
				}
			} else {
				echo '<br />' . $key . ': ' . print_r( $cart_item, true );
			}
		}
		echo '<br /><br />';
*/

	}
	add_filter( 'wpsc_calculate_total_tax', 'wpsc_wp_exclude_sales_tax' );
	//add_action( 'wpsc_before_checkout_cart_row', 'wpsc_wp_exclude_sales_tax' );

	function wpsc_wp_filter_products_visible() {

		add_action( 'pre_get_posts', 'wpsc_wp_filter_products_get_posts' );

	}
	add_action( 'init', 'wpsc_wp_filter_products_visible' );

	function wpsc_wp_filter_products_get_posts( $q ) {

		//print_r( $q->query_vars );
		return false;

	}

/*
	function wpsc_wp_tax_exemption() {

		$wpec_taxes->taxes_options['wpec_taxes_enabled'] = 0;

		global $wpsc_cart;

		$wpsc_cart->tax_percentage = 0.00;
		$wpsc_cart->total_tax = 0.00;
		if( $wpsc_cart->cart_items ) {
			foreach( $wpsc_cart->cart_items as $key => $cart_item ) {
				$wpsc_cart->cart_items[$key]->tax = 0.00;
				$wpsc_cart->cart_items[$key]->apply_tax = 0;
				$wpsc_cart->cart_items[$key]->tax_rate = 0;
			}
		}
		print_r( $wpsc_cart );
*/
		//print_r( $_SESSION['wpsc_cart'] );

		//global $wpec_taxes;

		//$wpec_taxes = new wpec_taxes();
		//$wpec_taxes->taxes_options['wpec_taxes_enabled'] = 0;

/*
		$options = array(
			'wpec_taxes_enabled' => 0
		);
		$wpec_taxes->wpec_taxes_set_options( $options );
		print_r( $wpec_taxes );

	}
	add_filter( 'wpec_taxes_get_rate', 'wpsc_wp_tax_exemption' );
*/

	function wpsc_wp_is_product_visible() {

		switch( wpsc_get_major_version() ) {

			case '3.7':
				$checkbox = get_product_meta( wpsc_the_product_id(), 'wpsc_wp_checkbox', true );
				break;

			case '3.8':

				global $post;

				$post_id = $post->ID;
				if( !$post_id )
					$post_id = $product_id;

				if( get_post_field( 'post_parent', $post_id ) )
					$parent_id = get_post_field( 'post_parent', $post_id );

				$product_data = get_post_custom( $post_id );
				$product_data['meta'] = maybe_unserialize( $product_data );
				if( $product_data['meta'] ) {
					foreach( $product_data['meta'] as $meta_key => $meta_value )
						$product_data['meta'][$meta_key] = $meta_value[0];
					$product_meta = maybe_unserialize( $product_data['_wpsc_product_metadata'][0] );
					if( isset( $product_meta['wpsc_wp_checkbox'] ) )
						$checkbox = $product_meta['wpsc_wp_checkbox'];
				}
				
				if ( isset( $parent_id ) ) {
					$parent_data = get_post_custom( $post_id );
					$parent_data['meta'] = maybe_unserialize( $parent_data );
					if( $parent_data['meta'] ) {
						foreach( $parent_data['meta'] as $meta_key => $meta_value )
							$parent_data['meta'][$meta_key] = $meta_value[0];
						$parent_meta = maybe_unserialize( $parent_data['_wpsc_product_metadata'][0] );
						if( isset( $parent_meta['wpsc_wp_checkbox'] ) )
							$parent_checkbox = $parent_meta['wpsc_wp_checkbox'];
					}
				}
				break;

		}

		if( is_user_logged_in() ) {
			global $current_user;
			get_currentuserinfo();
			$role = $current_user->roles[0];
		} else {
			$role = 'guest';
		}

		if( isset( $checkbox[$role] ) && $checkbox[$role] == 'on' ) {

			// User per-Product visibility for that User Role, including Site Visitors
			switch( wpsc_get_major_version() ) {

				case '3.7':
					$visibility = get_product_meta( wpsc_the_product_id(), 'wpsc_wp_visibility', true );
					break;

				case '3.8':
					$visibility = $product_meta['wpsc_wp_visibility'][$role];
					break;

			}

		} else if ( isset( $parent_checkbox[$role] ) && $parent_checkbox[$role] == 'on' ) {

			// User per-Product visibility for that User Role, including Site Visitors
			switch( wpsc_get_major_version() ) {

				case '3.7':
					$parent_id = get_post_field( 'post_parent', wpsc_the_product_id() );
					if ( $parent_id != 0 ) $visibility = get_product_meta( $parent_id, 'wpsc_wp_visibility', true );
					break;

				case '3.8':
					$visibility = $parent_meta['wpsc_wp_visibility'][$role];
					break;

			}

		} else {

			return true;

		}

		switch( $visibility ) {

			case '0':
				return false;
				break;

			case '1':
				return true;
				break;

		}
	}

	/* End of: Storefront */

}

/* Start of: Common */

/**
 * The Wholesale Pricing front-end function.
 *
 * The function is responsible for returning the adjusted Product price within the WP e-Commerce Product page.
 *
 * @param string $price Original price from WP e-Commerce.
 * @param string $product_id Optional, Product ID within WP e-Commerce.
 * @return string Adjusted Product price.
 */
function wpsc_wp_wholesale_price( $price, $product_id = null, $role = null ) {

	switch( wpsc_get_major_version() ) {

		case '3.8':

			global $post;

			if( isset( $product_id) )
				$post_id = $product_id;
			else if ( isset( $post->ID ) )
				$post_id = $post->ID;
			else
				return $price;

			$product_meta = maybe_unserialize( get_post_meta( $product_id, '_wpsc_product_metadata', true ) );

			if( get_post_field( 'post_parent', $post_id ) )
				$parent_id = get_post_field( 'post_parent', $post_id );
			if ( isset( $parent_id ) ) {
				$parent_meta = maybe_unserialize( get_post_meta( $parent_id, '_wpsc_product_metadata', true ) );
				if( isset( $parent_meta['wpsc_wp_disregard'] ) )
					$disregard_product = $parent_meta['wpsc_wp_disregard'];
			}

			break;

	}

	if( !isset( $disregard_product ) )
		$disregard_product = 'off';

	if( !$role ) {
		$role = 'guest';
		if( is_user_logged_in() ) {
			global $current_user;
			get_currentuserinfo();
			$role = $current_user->roles[0];
		}
	}

	$checkbox = false;
	switch( wpsc_get_major_version() ) {

		case '3.7':
			$checkbox = get_product_meta( wpsc_the_product_id(), 'wpsc_wp_checkbox', true );
			break;

		case '3.8':
			if( isset( $product_meta['wpsc_wp_checkbox'] ) )
				$checkbox = $product_meta['wpsc_wp_checkbox'];
			break;

	}

	if ( !isset( $checkbox[$role] ) || $checkbox[$role] == 'off' ) {
		$parent_checkbox = false;
		switch( wpsc_get_major_version() ) {

			case '3.7':
				$parent_id = get_post_field( 'post_parent', wpsc_the_product_id() );
				if( $parent_id != 0 )
					$parent_checkbox = get_product_meta( $parent_id, 'wpsc_wp_checkbox', true );
				break;

			case '3.8':
				if( isset( $parent_meta['wpsc_wp_checkbox'] ) )
					$parent_checkbox = $parent_meta['wpsc_wp_checkbox'];
				break;

		}
	}

	if( isset( $checkbox[$role] ) && $checkbox[$role] == 'on' ) {

		// User per-Product pricing for that User Role, including Site Visitors
		switch( wpsc_get_major_version() ) {

			case '3.7':
				$value = get_product_meta( wpsc_the_product_id(), 'wpsc_wp_value', true );
				$amount = get_product_meta( wpsc_the_product_id(), 'wpsc_wp_amount', true );
				$method = get_product_meta( wpsc_the_product_id(), 'wpsc_wp_method', true );
				$fixed = get_product_meta( wpsc_the_product_id(), 'wpsc_wp_fixed', true );
				break;

			case '3.8':
				$value = $product_meta['wpsc_wp_value'][$role];
				$amount = $product_meta['wpsc_wp_amount'][$role];
				$method = $product_meta['wpsc_wp_method'][$role];
				$fixed = $product_meta['wpsc_wp_fixed'][$role];
				break;

		}

	} else if( isset( $parent_checkbox[$role] ) && $parent_checkbox[$role] == 'on' ) {

		// User per-Product pricing for that User Role for parent product, including Site Visitors
		switch( wpsc_get_major_version() ) {

			case '3.7':
				$parent_id = get_post_field( 'post_parent', wpsc_the_product_id() );
				if( $parent_id != 0 ) {
					$value = get_product_meta( $parent_id, 'wpsc_wp_value', true );
					$amount = get_product_meta( $parent_id, 'wpsc_wp_amount', true );
					$method = get_product_meta( $parent_id, 'wpsc_wp_method', true );
					$fixed = get_product_meta( $parent_id, 'wpsc_wp_fixed', true );
				}
				break;

			case '3.8':
				$value = $parent_meta['wpsc_wp_value'][$role];
				$amount = $parent_meta['wpsc_wp_amount'][$role];
				$method = $parent_meta['wpsc_wp_method'][$role];
				$fixed = $parent_meta['wpsc_wp_fixed'][$role];
				break;

		}

	} else {

		$defaults = maybe_unserialize( get_option( 'wpsc_wp_defaults' ) );
		if( $role <> 'guest' ) {

			// Use default per-User Role pricing for that Product
			$value = $defaults[$role]['value'];
			$amount = $defaults[$role]['amount'];
			$method = $defaults[$role]['method'];

		} else {

			// Use default per-User Role pricing for that Product
			$value = $defaults['guest']['value'];
			$amount = $defaults['guest']['amount'];
			$method = $defaults['guest']['method'];

		}

	}

	if( isset( $fixed ) && ! wpsc_wp_is_empty_fixed_price( $fixed ) ) {

		$price = $fixed;

	} else if( $value && $amount && $method ) {

		if( $amount > 0 ) {
			switch( $method ) {

				case '$':
					switch( $value ) {

						case '+':
						default:
							$price = $price + $amount;
							break;

						case '-':
							$price = $price - $amount;
							break;

					}
					break;

				case '%':
					switch( $value ) {

						case '+':
						default:
							$price = $price + ( ( $price / 100 ) * $amount );
							break;

						case '-':
							$price = $price - ( ( $price / 100 ) * $amount );
							break;

					}
					break;

			}
		}
		if( $price < 0 )
			$price = 0;

	}
	return $price;

}
add_filter( 'wpsc_do_convert_price', 'wpsc_wp_wholesale_price', 10, 1 );
add_filter( 'wpsc_price', 'wpsc_wp_wholesale_price', 10, 2 );

function wpsc_wp_is_empty_fixed_price( $price ) {

	switch( $price ) {

		case '0';
		case '0.00':
			return true;
			break;

	}

}

function wpsc_wp_get_user_role( $user_id = null ) {

	$output = '';
	if( $user_id ) {
		$user = new WP_User( $user_id );
		if( !empty( $user->roles ) && is_array( $user->roles ) ) {
			foreach( $user->roles as $role )
				$output = $role;
		}
	}
	return $output;

}

function wpsc_wp_get_roles() {

	$roles = get_editable_roles();
	$roles['guest'] = array( 'name' => 'Site Visitor / Guest' );
	return $roles;

}

/* End of: Common */
?>