<?php
if( is_admin() ) {

	/* Start of: WordPress Administration */

	/* WordPress Administration menu */
	function wpsc_wp_admin_menu() {

		add_options_page( __( 'Wholesale Pricing for WP e-Commerce', 'wpsc_wp' ), __( 'Wholesale Pricing', 'wpsc_wp' ), 'manage_options', 'wpsc_wp', 'wpsc_wp_html_page' );

	}
	add_action( 'admin_menu', 'wpsc_wp_admin_menu' );

	function wpsc_wp_init_meta_box() {

		$pagename = 'wpsc-product';
		$post_id = isset( $_GET['post'] ) ? $_GET['post'] : 0;

		add_meta_box( 'wpsc_wp_meta_box', __( 'Wholesale Pricing', 'wpsc_wp' ), 'wpsc_wp_meta_box', $pagename, 'normal', 'default' );
		if( get_post_field( 'post_parent', $post_id ) )
			remove_meta_box( 'wpsc_wp_meta_box', 'wpsc-product', 'side' );

	}
	add_action( 'load-post.php', 'wpsc_wp_init_meta_box' );
	add_action( 'load-post-new.php', 'wpsc_wp_init_meta_box' );

	function wpsc_wp_add_to_product_form( $order ) {

		if( array_search( 'wpsc_wp_meta_box', (array)$order['side'] ) === false )
			$order['side'][] = 'wpsc_wp_meta_box';

		return $order;

	}
	add_filter( 'wpsc_products_page_forms', 'wpsc_wp_add_to_product_form' );

	function wpsc_wp_meta_box() {

		global $post, $wpdb, $closed_postboxes, $wpsc_wp;

		$editable_roles = wpsc_wp_get_roles();

		// Defaults
		$checkbox = false;
		$value = array();
		$amount = array();
		$method = array();
		$fixed = array();
		$visibility = array();
		foreach( $editable_roles as $role => $details ) {
			$value[$role] = '+';
			$amount[$role] = 0;
			$method[$role] = '%';
			$fixed[$role] = 0;
			$visibility[$role] = 1;
		}
		$disregard_product = 'off';
		$product_meta = maybe_unserialize( get_post_meta( $post->ID, '_wpsc_product_metadata', true ) );
		if( $product_meta ) {
			if( isset( $product_meta['wpsc_wp_checkbox'] ) )
				$checkbox = $product_meta['wpsc_wp_checkbox'];
			else
				$checkbox = false;
			if( isset( $product_meta['wpsc_wp_value'] ) )
				$value = array_merge( $value, $product_meta['wpsc_wp_value'] );
			if( isset( $product_meta['wpsc_wp_amount'] ) )
				$amount = array_merge( $amount, $product_meta['wpsc_wp_amount'] );
			if( isset( $product_meta['wpsc_wp_method'] ) )
				$method = array_merge( $method, $product_meta['wpsc_wp_method'] );
			if( isset( $product_meta['wpsc_wp_visibility'] ) )
				$visibility = array_merge( $visibility, $product_meta['wpsc_wp_visibility'] );
			if( isset( $product_meta['wpsc_wp_fixed'] ) )
				$fixed = array_merge( $fixed, $product_meta['wpsc_wp_fixed'] );
			if( isset( $product_meta['wpsc_wp_disregard'] ) )
				$disregard_product = $product_meta['wpsc_wp_disregard'];
		}
		$currency_args = array(
			'display_currency_symbol' => false,
			'display_as_html' => false
		);
		foreach( $editable_roles as $key => $role ) {
			if( !isset( $method[$key] ) || $method[$key] == '%' )
				$amount[$key] = (int)$amount[$key];
			else
				$amount[$key] = wpsc_currency_display( $amount[$key], $currency_args );
		}

		include( $wpsc_wp['abspath'] . '/templates/admin/wpsc-admin_wp_product_38.php' );

	}
	
	function wpsc_wp_product_variants_columns( $columns ) {

		$columns['wholesale_pricing'] = 'Wholesale Pricing';
		return $columns;

	}
	add_filter( 'manage_wpsc-product_variants_columns', 'wpsc_wp_product_variants_columns', 20 );
	
	function wpsc_wp_manage_posts_custom_column( $column_name, $product_id ) {

		if ( $column_name == 'wholesale_pricing' ) {
			$edit_link = get_edit_post_link( $product_id );
			$edit_link = wp_nonce_url( $edit_link, 'edit-product_'.$product_id );
			echo '<a href="' . $edit_link . '/#wpsc_product_wholesale_pricing">Set Wholesale Pricing</a>';
		}

	}
	add_action( 'manage_posts_custom_column', 'wpsc_wp_manage_posts_custom_column', 10, 2 );

	function wpsc_wp_insert_wholesale_price( $product_id, $user_role = '', $wholesale_price, $existing_meta = '' ) {

		/* Product Importer Deluxe integration */
		if( $existing_meta )
			$product_meta = $existing_meta;
		else
			$product_meta = maybe_unserialize( get_post_meta( $product_id, '_wpsc_product_metadata', true ) );

		if( $user_role ) {

			if( !isset( $product_meta['wpsc_wp_checkbox'] ) )
				$product_meta['wpsc_wp_checkbox'] = array();
			if( !isset( $product_meta['wpsc_wp_value'] ) )
				$product_meta['wpsc_wp_value'] = array();
			if( !isset( $product_meta['wpsc_wp_amount'] ) )
				$product_meta['wpsc_wp_amount'] = array();
			if( !isset( $product_meta['wpsc_wp_method'] ) )
				$product_meta['wpsc_wp_method'] = array();
			if( !isset( $product_meta['wpsc_wp_fixed'] ) )
				$product_meta['wpsc_wp_fixed'] = array();
			if( !isset( $product_meta['wpsc_wp_visibility'] ) )
				$product_meta['wpsc_wp_visibility'] = array();

			$product_meta['wpsc_wp_checkbox'][$user_role] = 'on';
			$product_meta['wpsc_wp_value'][$user_role] = '+';
			$product_meta['wpsc_wp_amount'][$user_role] = 0;
			$product_meta['wpsc_wp_method'][$user_role] = '$';
			$product_meta['wpsc_wp_fixed'][$user_role] = 0;
			$product_meta['wpsc_wp_visibility'][$user_role] = 1;

			if( $wholesale_price == '-' ) { // Disable per-Product pricing
				unset( $product_meta['wpsc_wp_checkbox'][$user_role] );
			} else if( !empty( $wholesale_price ) ) {
				if( substr( $wholesale_price, -1, 1 ) == '%' ) { // Detect percent-based pricing rule
					if( $wholesale_price[0] == '-' ) // Detect mark-down
						$product_meta['wpsc_wp_value'][$user_role] = '-';
					$product_meta['wpsc_wp_method'][$user_role] = '%';
					if( $wholesale_price[0] == '-' || $wholesale_price[0] == '+' )
						$product_meta['wpsc_wp_amount'][$user_role] = substr( $wholesale_price, 1, -1 );
					else
						$product_meta['wpsc_wp_amount'][$user_role] = substr( $wholesale_price, 0, -1 );
				} else if( $wholesale_price[0] == '-' || $wholesale_price[0] == '+' ) {
					if( $wholesale_price[0] == '-' ) // Detect mark-down
						$product_meta['wpsc_wp_value'][$user_role] = '-';
					if( $wholesale_price[0] == '-' || $wholesale_price[0] == '+' )
						$product_meta['wpsc_wp_amount'][$user_role] = substr( $wholesale_price, 1 );
					else
						$product_meta['wpsc_wp_amount'][$user_role] = $wholesale_price;
				} else { // Detect fixed pricing
					$product_meta['wpsc_wp_fixed'][$user_role] = $wholesale_price;
				}
			}

		}

		if( $existing_meta )
			return $product_meta;
		else
			update_post_meta( $product_id, '_wpsc_product_metadata', $product_meta );

	}

	/* Add/Edit Categories */
/*
	function wpsc_wp_admin_categories_edit() {

		global $wpsc_wp;

		$editable_roles = wpsc_wp_get_roles();		

		include( $wpsc_wp['abspath'] . '/templates/admin/wpsc-admin_wp_category_38.php' );

	}
	add_action( 'wpsc_product_category_edit_form_fields', 'wpsc_wp_admin_categories_edit' );
*/

	/* End of: WordPress Administration */

} else {

	/* Start of: Storefront */

/*
	class wpsc_pe_filter_products_class {

		var $q;

		function get_posts( &$q ) {

			$this->q =& $q;
			$term_taxonomy = 'wpsc_product_category';
			print_r( $q->query_vars );
			if( ( !isset( $q->query_vars['taxonomy'] ) || ( $term_taxonomy != $q->query_vars['taxonomy'] ) ) )
				return false;

			add_action( 'posts_where', array( &$this, 'where' ) );
			add_action( 'posts_join', array( &$this, 'join' ) );

		}

		function where( $where ) {

			global $wpdb;

			remove_action( 'posts_where', array( &$this, 'where' ) );

			$term_id= $wpdb->get_var( $wpdb->prepare( 'SELECT term_id FROM '.$wpdb->terms.' WHERE slug = %s ', $this->q->query_vars['term'] ) );

			if( !is_numeric( $term_id ) || $term_id < 1 )
				return $where;

			$term_taxonomy_id = $wpdb->get_var( $wpdb->prepare( 'SELECT term_taxonomy_id FROM ' . $wpdb->term_taxonomy . ' WHERE term_id = %d and taxonomy = %s', $term_id, $this->q->query_vars['taxonomy'] ) );

			if( !is_numeric( $term_taxonomy_id ) || $term_taxonomy_id < 1 )
				return $where;

			$field = preg_quote( "$wpdb->term_relationships.term_taxonomy_id", '#' );

			$just_one = $wpdb->prepare( " AND $wpdb->term_relationships.term_taxonomy_id = %d ", $term_taxonomy_id );
			if( preg_match( "#AND\s+$field\s+IN\s*\(\s*(?:['\"]?\d+['\"]?\s*,\s*)*['\"]?\d+['\"]?\s*\)#", $where, $matches ) )
				$where = str_replace( $matches[0], $just_one, $where );
			else
				$where .= $just_one;

			return $where;

		}

		function join( $join ) {

			global $wpdb;

			remove_action( 'posts_where', array( &$this, 'where' ) );
			remove_action( 'posts_join', array( &$this, 'join' ) );
			if( strpos( $join, "JOIN $wpdb->term_relationships ON ($wpdb->posts.ID = $wpdb->term_relationships.object_id)" ) )
				return $join;
			$join .= " JOIN $wpdb->term_relationships ON ($wpdb->posts.ID = $wpdb->term_relationships.object_id)";
			return $join;

		}

	}
*/

	function wpsc_pe_filter_products( $wp_query ) {

		if( isset( $wp_query->query_vars['pagename'] ) && $wp_query->query_vars['pagename'] == 'products-page' ) {
			$wp_query->set( 'p', '-59880' );
		}

	}
	//add_action( 'pre_get_posts', 'wpsc_pe_filter_products', 12 );

			//set_query_var('post_parent', '-59880' );
			//$wp_query->set( 'post__not_in', array( 59880 ) );
			//set_query_var( 'post__not_in' => array( 59880 ) );
/*
		$filter_products = new wpsc_pe_filter_products_class;
		add_action( 'pre_get_posts', array( &$filter_products, 'get_posts' ) );
*/

/*
		global $wp_query, $wpsc_query, $wpsc_query_vars;

		print_r( $wpsc_query );
		if( $wpsc_query ) {
			foreach( $wpsc_query as $wpsc_query_key => $wpsc_query_item ) {
				echo $wpsc_query_key . ': ' . print_r( $wpsc_query_item ) . '<br />';
			}
		}
*/

	//add_action( 'init', 'wpsc_pe_filter_products' );

	/* End of: Storefront */

}
?>