<?php
/*
Plugin Name: WP e-Commerce - Wholesale Pricing
Plugin URI: http://www.visser.com.au/wp-ecommerce/plugins/wholesale-pricing/
Description: Add wholesale pricing controls to your WP e-Commerce store.
Version: 1.7.9
Author: Visser Labs
Author URI: http://www.visser.com.au/about/
License: GPL2
*/

load_plugin_textdomain( 'wpsc_wp', null, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

include_once( 'includes/functions.php' );

include_once( 'includes/common.php' );

switch( wpsc_get_major_version() ) {

	case '3.7':
		include_once( 'includes/release-3_7.php' );
		break;

	case '3.8':
		include_once( 'includes/release-3_8.php' );
		break;

}

$wpsc_wp = array(
	'filename' => basename( __FILE__ ),
	'dirname' => basename( dirname( __FILE__ ) ),
	'abspath' => dirname( __FILE__ ),
	'relpath' => basename( dirname( __FILE__ ) ) . '/' . basename( __FILE__ )
);

$wpsc_wp['prefix'] = 'wpsc_wp';
$wpsc_wp['name'] = __( 'Wholesale Pricing for WP e-Commerce', 'wpsc_wp' );
$wpsc_wp['menu'] = __( 'Wholesale Pricing', 'wpsc_wp' );

if( is_admin() ) {

	/* Start of: WordPres Administration */

	include_once( 'includes/install.php' );
	register_activation_hook( __FILE__, 'wpsc_wp_install' );
	include_once( dirname( __FILE__ ) . '/includes/update.php' );

	function wpsc_wp_add_settings_link( $links, $file ) {

		static $this_plugin;
		if( !$this_plugin ) $this_plugin = plugin_basename( __FILE__ );
		if( $file == $this_plugin ) {
			$settings_link = '<a href="options-general.php?page=wpsc_wp">' . __( 'Settings', 'wpsc_wp' ) . '</a>';
			array_unshift( $links, $settings_link );
		}
		return $links;

	}
	add_filter( 'plugin_action_links', 'wpsc_wp_add_settings_link', 10, 2 );

	function wpsc_wp_html_page() {

		global $wpsc_wp;

		$action = wpsc_get_action();
		wpsc_wp_template_header();
		switch( $action ) {

			case 'update':
				$checkbox = $_POST['checkbox'];
				$value = $_POST['value'];
				$amount = $_POST['amount'];
				$method = $_POST['method'];
				$visibility = $_POST['visibility'];
				$sales_tax = $_POST['sales_tax'];
				$editable_roles = wpsc_wp_get_roles();

				$roles = array();
				foreach( $editable_roles as $role => $details ) {
					switch( $checkbox[$role] ) {

						case 'on':
							$roles[$role] = array( 'status' => 'on', 'value' => $value[$role], 'amount' => $amount[$role], 'method' => $method[$role], 'visibility' => $visibility[$role], 'sales_tax' => $sales_tax[$role] );
							break;

						case 'off':
						default:
							$roles[$role] = array( 'status' => 'off', 'value' => $value[$role], 'amount' => $amount[$role], 'method' => $method[$role], 'visibility' => $visibility[$role], 'sales_tax' => $sales_tax[$role] );
							break;

					}
				}

				if( $roles ) {
					$roles = serialize( $roles );
					update_option( 'wpsc_wp_defaults', $roles );
				}

				$message = __( 'Settings saved.', 'wpsc_wp' );
				$output = '<div class="updated settings-error"><p>' . $message . '</p></div>';
				echo $output;

				wpsc_wp_options_form();
				break;

			default:
				wpsc_wp_options_form();
				break;

		}
		wpsc_wp_template_footer();

	}

	function wpsc_wp_options_form() {

		global $wpsc_wp;

		$defaults = maybe_unserialize( get_option( $wpsc_wp['prefix'] . '_defaults' ) );
		$editable_roles = wpsc_wp_get_roles();
		$users_of_blog = count_users();
		$avail_roles =& $users_of_blog['avail_roles'];
		unset( $users_of_blog );
		$visibility = get_option( $wpsc_wp['prefix'] . '_visibility' );
		$visibilities = array();
		$visibilities[] = array( 'show', __( 'Show Products', 'wpsc_wp' ) );
		$visibilities[] = array( 'hide', __( 'Hide Products', 'wpsc_wp' ) );

		include( 'templates/admin/wpsc-admin_wp_settings.php' );

	}

	/* End of: WordPress Administration */

} else {

	/* Start of: Storefront */

	include_once( 'includes/legacy.php' );

	include_once( 'includes/template.php' );

	/* End of: Storefront */

}
?>