<?php
/*
Plugin Name: WP e-Commerce Featured Products
Plugin URI: http://wpectheme/featured-products-plugin/
Description: This is a WP e-Commerce plugin that allows you to hide the price of a specific product and repplace it with a message asking your customers to call for price.
Version: 1.0
Author: Margart
Author URI: 
License: GPL2


*/

if (!defined('PHP_VERSION_ID')) {

    $version = explode('.', PHP_VERSION);

    define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));

}


if (file_exists('../wp-admin/includes/plugin.php')){
    require_once('../wp-admin/includes/plugin.php');
}

define('WPEC_FEATURED_PRODUCTS_VERSION', '1.0');

define('WPEC_FEATURED_PRODUCTS_PLUGIN_PATH',   plugin_basename(__FILE__) );

if ( PHP_VERSION_ID < 50300 ) {

    wp_die('<div class="error"><p>'.__("The WPEC Featured Products plugin requieres PHP version not less then 5.3", 'wpecfp').'</p></div>');

    if(is_plugin_active(WPEC_FEATURED_PRODUCTS_PLUGIN_PATH)) {

        deactivate_plugins(WPEC_FEATURED_PRODUCTS_PLUGIN_PATH);

    }
}


class WPECFeaturedProductsWidget extends WP_Widget{

  public function __construct(){
      parent::__construct('wpecfp', 'WPEC Featured Products',
          array('description' => __('WP E-Commerce Featured Products Widget', 'wpec'))
        );    
  }

  public function getFeaturedProducts($prod_num){
      global $wp_query;
      $sticky_array = get_option( 'sticky_products' );
      
   
      if (!empty( $sticky_array )) {
        $query = get_posts( array(
              'post__in' => $sticky_array,
               'post_type' => 'wpsc-product',
               'orderby' => 'rand',
               'numberposts' => $prod_num,
               
            ) );
         
          if ( count( $query ) > 0 )  return $query; else return null;
       }
  }

  public function widget($args, $instance){

    global $wpdb, $table_prefix;

    extract( $args );

    $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? __( 'Featured Products', 'wpsc' ) : $instance['title'] );

    echo $before_widget;

    if ( $title ) echo $before_title . $title . $after_title;

   
    $prod_num  =  $instance['prod_num'];
    $prod_num_in_row  =  $instance['prod_num_in_row'];
    $prod_margin  =  $instance['prod_margin'];

    $show_desc   =  $instance['show_desc'];
    $im_height   =  $instance['im_height'];
    $im_width    =  $instance['im_width'];
    $desc_length =  $instance['desc_length'];
    $show_img    =  $instance['show_img'];
    $show_but    =  $instance['show_but'];

    //print_r($this->getFeaturedProducts($instance['prod_num']));

    function substr_words ($paragraph, $num_words) {
      $paragraph = explode (' ', $paragraph);
      $paragraph = array_slice ($paragraph, 0, $num_words);
      return implode (' ', $paragraph);
    }

    function has_vars($prod_id){
      if ( $prod_id > 0 ) {
     
         $wpefp_variations = new wpsc_variations( $prod_id );
        
        if ($wpefp_variations  != NULL) if (count($wpefp_variations->variation_groups)) return true; else return false;
 
       }
    }  
  if (!function_exists('changeSign')) {
    function changeSign($str){
        
         if ((wpsc_get_currency_symbol() != '') && (strlen(wpsc_get_currency_symbol()) == 1)) {
          $str = preg_replace("/^.*(".(wpsc_get_currency_symbol() == '$' ? '\\'.wpsc_get_currency_symbol(): wpsc_get_currency_symbol())."){1}.*?/", '<span class="csymb">'.wpsc_get_currency_symbol().'</span>', $str);
          	return $str;
       } 
      return $str;

    }
}

function wpecfp_product_on_special($prod_id) {
  global $wpsc_query, $wpdb;
 
  

  $price =  get_product_meta( get_the_ID(), 'price', true );

  // don't rely on product sales price if it has variations
  if ( has_vars($prod_id) ) {
    $sql = $wpdb->prepare("
      SELECT MIN(pm.meta_value)
      FROM {$wpdb->posts} AS p
      INNER JOIN {$wpdb->postmeta} AS pm ON pm.post_id = p.id AND pm.meta_key = '_wpsc_special_price' AND pm.meta_value != '0' AND pm.meta_value != ''
      INNER JOIN {$wpdb->postmeta} AS pm2 ON pm2.post_id = p.id AND pm2.meta_key = '_wpsc_stock' AND pm2.meta_value != '0'
      WHERE
        p.post_type = 'wpsc-product'
        AND
        p.post_parent = %d
      ORDER BY CAST(pm.meta_value AS DECIMAL(10, 2)) ASC
      LIMIT 1
    ", get_the_id() );
    $special_price = (int) $wpdb->get_var( $sql );
  } else {
    $special_price = get_product_meta( get_the_ID(), 'special_price', true );
  }

  if ( ($special_price > 0) && (($price - $special_price) > 0) )
    return true;
  else
    return false;

}

   ?>
   
   <style>
   .featured_products li{
	   width:<?php echo floor(90/$prod_num_in_row);?>%;
   }
   </style>
   
   
   <ul class="featured_products">
   <?php $i = 0; foreach(@$this->getFeaturedProducts($prod_num) as $product): $i++; ?>
   <?php setup_postdata( $product ); global $post; $old_post = $post; $post = $product; ?>
      <li <?php if(!($i%$prod_num_in_row)) : ?> class="omega" <?php endif; ?> >
         
              <?php if (wpecfp_product_on_special(wpsc_the_product_id())) : ?><span class="sale"><?php _e('Sale', 'wpsc'); ?></span><?php  endif; ?>
              <?php if ($show_img) : ?>
                <?php if ( wpsc_the_product_thumbnail ( )) : ?>
                 <div class="featured_item_image">
                    <a class="<?php echo wpsc_the_product_image_link_classes(); ?>" href="<?php echo wpsc_the_product_image(); ?>">
                <img class="product_image" id="featured_product_image_<?php echo wpsc_the_product_id(); ?>" alt="<?php echo wpsc_the_product_title(); ?>" title="<?php echo wpsc_the_product_title(); ?>" src="<?php echo wpsc_the_product_thumbnail($im_width, $im_height); ?>"/>

              </a>
                </div>

              <?php else: ?>

                <div class="item_no_image">
                    <a href="<?php echo get_the_title( $product->ID ); ?>"><span><?php _e('No Image Available', 'wpecfp') ?></span></a>
                </div><?php endif; ?>
              <?php  endif; ?>
               		<div class="featured-products-content">
                    <h3><a href='<?php echo get_permalink( $product->ID ); ?>'><?php echo get_the_title( $product->ID ); ?></a></h3>
                      <div class="pricedisplay featured_product_price">
                       <?php  if(has_vars(wpsc_the_product_id())) : ?>
                        
                    
                        <?php echo changeSign(wpsc_the_product_price()); ?>


                      <?php else: ?> 
                        



                  <?php if(wpecfp_product_on_special(wpsc_the_product_id())) : ?>
                    <p class="pricedisplay product_<?php echo wpsc_the_product_id(); ?>"><span class="price_old"><?php _e('Old Price', 'wpsc'); ?>:</span><span class="oldprice" id="old_featured_product_price_<?php echo wpsc_the_product_id(); ?>"><?php  echo wpsc_product_normal_price(); ?></span></p>
                  <?php endif; ?>
                  <p class="pricedisplay product_<?php echo wpsc_the_product_id(); ?>"><span class="price_price"><?php _e('Price', 'wpsc'); ?>:</span> <span id='featured_product_price_<?php echo wpsc_the_product_id(); ?>' class="currentprice pricedisplay"><?php  echo changeSign(wpsc_the_product_price()); ?></span></p>
                  


                  <?php if(wpecfp_product_on_special(wpsc_the_product_id())) : ?>
                    <p class="pricedisplay product_<?php echo wpsc_the_product_id(); ?>"><span class="price_yousave"><?php _e('You save', 'wpsc'); ?>:</span> <span class="yousave" id="yousave_<?php echo wpsc_the_product_id(); ?>"><?php echo changeSign(wpsc_currency_display(wpsc_you_save('type=amount'), array('display_as_html'=>false)) ); ?> (<?php echo wpsc_you_save(); ?>%)</span></p>
                  <?php endif; ?>


                      <?php endif; ?> 
                      </div>
                      <?php if(wpsc_product_has_multicurrency()) : ?>
                        <?php echo wpsc_display_product_multicurrency(); ?>
                      <?php endif; ?>
                      <?php if(wpsc_show_pnp()) : ?>
                        <p class="pricedisplay"><span class="price_shipping"><?php _e('Shipping', 'wpsc'); ?>:</span> <span class="pp_price"><?php echo wpsc_product_postage_and_packaging(); ?></span></p>
                      <?php endif; ?> 
                   <?php if ($show_desc) : ?>
                    <div class='wpsc_description'>
                        <?php echo substr_words(wpsc_the_product_description(), $desc_length ) ?>
                          <a href='<?php echo get_permalink( $product->ID ); ?>'>
                            <?php _e('More Information&hellip;', 'wpecfp') ?>
                          </a>
                    </div>
                  <?php endif; ?>

                  <?php if ($show_but) : ?>
                       
                       <?php if(!has_vars(wpsc_the_product_id())) : ?>
                        <form class="product_form"  enctype="multipart/form-data" action="<?php echo $action; ?>" method="post" name="product_<?php echo wpsc_the_product_id(); ?>" id="featured_product_<?php echo wpsc_the_product_id(); ?>" >
                        <?php do_action ( 'wpsc_product_form_fields_begin' ); ?>
                          
                          <?php if(wpsc_has_multi_adding()): ?>
                            <div class="quntity">
                              <div class="legend"><?php _e('Quantity:', 'wpsc'); ?></div>

                                <div class="wpsc_quantity_update">
                                  <input type="text" id="wpsc_featured_quantity_update_<?php echo wpsc_the_product_id(); ?>" name="wpsc_quantity_update" size="2" value="1" />
                                  <input type="hidden" name="key" value="<?php echo wpsc_the_cart_item_key(); ?>"/>
                                  <input type="hidden" name="wpsc_update_quantity" value="true" />
                                </div><!--close wpsc_quantity_update--> 
                              <div class="clear"></div>
                            </div>
                          <?php endif ;?>

                          <input type="hidden" value="add_to_cart" name="wpsc_ajax_action"/>
                          <input type="hidden" value="<?php echo wpsc_the_product_id(); ?>" name="product_id"/>
                      
                          <!-- END OF QUANTITY OPTION -->
                          <?php if((get_option('hide_addtocart_button') == 0) &&  (get_option('addtocart_or_buynow') !='1')) : ?>
                            <?php if(wpsc_product_has_stock()) : ?>
                              <div class="wpsc_buy_button_container">
                                <div class="wpsc_loading_animation">
                                  <img title="Loading" alt="Loading" src="<?php echo wpsc_loading_animation_url(); ?>" />
                                  <?php _e('Updating cart...', 'wpsc'); ?>
                                </div><!--close wpsc_loading_animation-->
                                  <?php if(wpsc_product_external_link(wpsc_the_product_id()) != '') : ?>
                                  <?php $action = wpsc_product_external_link( wpsc_the_product_id() ); ?>
                                  <button class=" wpsc_buy_button reverse" type="submit" value="<?php echo wpsc_product_external_link_text( wpsc_the_product_id(), __( 'Buy Now', 'wpsc' ) ); ?>" onclick="return gotoexternallink('<?php echo $action; ?>', '<?php echo wpsc_product_external_link_target( wpsc_the_product_id() ); ?>')"><span><?php _e( 'Buy Now', 'wpsc' )?></span></button>
                                  <?php else: ?>
                                <button type="submit" name="Buy" class="wpsc_buy_button reverse" id="featured_product_<?php echo wpsc_the_product_id(); ?>_submit_button"><span><?php _e('Add To Cart', 'wpsc'); ?></span></button>
                                  <?php endif; ?>
                              </div><!--close wpsc_buy_button_container-->
                            <?php endif ; ?>
                          <?php endif ; ?>
                          
                          
                        </form><!--close product_form-->
                        
                        <?php else : ?>
                        <div class="wpsc_buy_button_container">
                          <a class="button wpsc_buy_button" href="<?php echo get_permalink( $product->ID ); ?>"><span><?php _e('Details', 'wpsc'); ?></span></a>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                </div>
        </li>
       
      <?php if(!($i%$prod_num_in_row)) echo '<li class="clear"></li>'; ?>

    <?php endforeach; ?>

  </ul>
  <div class="clear"></div>

    <?php echo $after_widget;
  }

  function form( $instance ){
    
    global $wpdb;

    // Defaults
    $instance = wp_parse_args( (array)$instance, array(
      'title' => '',
      'prod_num' => 4,
      'prod_margin' => 3,
      'prod_num_in_row' => 4,
      'show_img' => true,
      'im_width' => 140,
      'im_height' => 370,
      'show_desc' => true,
      'desc_length' => 140,
      'show_but' => true
    ) );

   

    $title    = esc_attr( $instance['title'] );
    $prod_num = $instance['prod_num'];
    $prod_num_in_row  =  $instance['prod_num_in_row'];
    $prod_margin  =  $instance['prod_margin'];
    $show_desc  =  ($instance['show_desc'] == 'on'? true:false);
    $im_height  = $instance['im_height'];
    $im_width   = $instance['im_width'];
    $desc_length=  $instance['desc_length'];
    $show_img   =  ($instance['show_img'] == 'on'? true:false);
    $show_but   =  ($instance['show_but'] == 'on'? true:false);

  

    ?>

    <p>
      <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title:', 'wpecfp' ); ?></label>
      <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
    </p>

    <p>
      <label for="<?php echo $this->get_field_id( 'prod_number' ); ?>"><?php _e( 'Number of products to show:', 'wpecfp' ); ?></label>
      <input type="text" id="<?php echo $this->get_field_id( 'prod_number' ); ?>" name="<?php echo $this->get_field_name( 'prod_num' ); ?>" value="<?php echo $prod_num; ?>" size="3" />
    </p>

     <p>
      <label for="<?php echo $this->get_field_id( 'prod_num_in_row' ); ?>"><?php _e( 'Number of products in a row:', 'wpecfp' ); ?></label>
      <input type="text" id="<?php echo $this->get_field_id( 'prod_num_in_row' ); ?>" name="<?php echo $this->get_field_name( 'prod_num_in_row' ); ?>" value="<?php echo $prod_num_in_row; ?>" size="3" />
    </p>

     <p>
      <label for="<?php echo $this->get_field_id( 'prod_margin' ); ?>"><?php _e( 'Margin between products:', 'wpecfp' ); ?></label>
      <input type="text" id="<?php echo $this->get_field_id( 'prod_margin' ); ?>" name="<?php echo $this->get_field_name( 'prod_margin' ); ?>" value="<?php echo $prod_margin; ?>" size="3" /> %
    </p>

    <p>
      <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_img' ); ?>" name="<?php echo $this->get_field_name( 'show_img' ); ?>" <?php checked($show_img); ?> onclick="jQuery('.wpsc_latest_image').toggle()">
      <label for="<?php echo $this->get_field_id( 'show_img' ); ?>"><?php _e( 'Show Thumbnails', 'wpecfp' ); ?></label>
    </p>

    <div class="wpsc_latest_image"<?php if( !checked( $show_img ) ) { echo ' style="display:none;"'; } ?>>
      <p>
        <label for="<?php echo $this->get_field_id('im_width'); ?>"><?php _e('Width:', 'wpecfp'); ?></label>
        <input type="text" id="<?php echo $this->get_field_id('im_width'); ?>" name="<?php echo $this->get_field_name('im_width'); ?>" value="<?php echo $im_width ; ?>" size="3" />
        <label for="<?php echo $this->get_field_id('im_height'); ?>"><?php _e('Height:', 'wpecfp'); ?></label>
        <input type="text" id="<?php echo $this->get_field_id('im_height'); ?>" name="<?php echo $this->get_field_name('im_height'); ?>" value="<?php echo $im_height ; ?>" size="3" />
      </p>
    </div>

    <p>
      <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_desc' ); ?>" name="<?php echo $this->get_field_name( 'show_desc' ); ?>" <?php checked($show_desc); ?> onclick="jQuery('.wpecfp_prod_desc').toggle()">
      <label for="<?php echo $this->get_field_id( 'show_desc' ); ?>"><?php _e( 'Show Description', 'wpecfp' ); ?></label>
    </p>
    <div class="wpecfp_prod_desc"<?php if( !checked( $show_desc ) ) { echo ' style="display:none;"'; } ?>>
      <p>
        <label for="<?php echo $this->get_field_id('desc_length'); ?>"><?php _e('Description length:', 'wpecfp'); ?></label>
        <input type="text" id="<?php echo $this->get_field_id('desc_length'); ?>" name="<?php echo $this->get_field_name('desc_length'); ?>" value="<?php echo $desc_length ; ?>" size="3" />
      </p>
    </div>
     <p>
      <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_but' ); ?>" name="<?php echo $this->get_field_name( 'show_but' ); ?>" <?php checked($show_but); ?> >
      <label for="<?php echo $this->get_field_id( 'show_but' ); ?>"><?php _e( 'Show View Button', 'wpecfp' ); ?></label>
    </p>

<?php  

  }

  function update($old_instance, $new_instance){
    $instance = $old_instance;
    


    $instance['prod_num']   = (int)$old_instance['prod_num'];
    $instance['prod_num_in_row']   = (int)$old_instance['prod_num_in_row'];
    $instance['prod_margin']   = (int)$old_instance['prod_margin'];
    $instance['show_desc']  =  ($old_instance['show_desc'] == 'on'? true:false);
    $instance['im_height']  = (int)$old_instance['im_height'];
    $instance['im_width']   = (int)$old_instance['im_width'];
    $instance['desc_length']= (int)$old_instance['desc_length'];
    $instance['show_img']   =  ($old_instance['show_img'] == 'on'? true:false);
    $instance['show_but']   =  ($old_instance['show_but'] == 'on'? true:false);
    

    
    return $instance;
  }


}


class WPECFeaturedProducts{

   function __construct(){

       add_action('plugins_loaded', array($this, 'init'), 9);


   }


   function init(){

       if($this->check_wpec_plugin()){


          //add_action( 'widgets_init', 'wpecfp_widget' );
          add_action( 'widgets_init', create_function( '', 'register_widget( "WPECFeaturedProductsWidget" );' ) );
          add_action('wp_enqueue_scripts', array($this, 'load_front_end_css'));
          
          if (is_admin()){
              // add_action( 'admin_init', array($this, 'register_wpecfpsettings') );
          }

          load_plugin_textdomain( 'wpecfp', false, dirname( plugin_basename( __FILE__ ) ) . '/locales/' );

       }
   }

    


   function show_wpec_missing_notice(){

       printf('<div class="error"><p>'.__("The Featured Products Plugin will not work without WP e-Commerce plugin.", 'wpecfp').'</p></div>');

       printf('<div class="updated"><p>'.__('Please install <a href="http://wordpress.org/extend/plugins/wp-e-commerce/">WP e-Commerce plugin</a>', 'wpecfp').'</p></div>');

   }

   function load_front_end_js(){

       wp_enqueue_script('jquery');
     //  wp_enqueue_script('wpecfeaturedproducts_js', plugins_url('/js/wpecfp.js',__FILE__), array('jquery'), '', false );

   }

   function load_back_end_js(){

      

   }

   function load_front_end_css(){

       wp_register_style( 'wpecfp-style', plugins_url('/css/wpecfp.css', __FILE__) );
       wp_enqueue_style( 'wpecfp-style' );

   }



    

    function on_activate(){

        

    }


   function check_wpec_plugin(){

        if ( !class_exists('WP_eCommerce') ){

            deactivate_plugins(WPEC_FEATURED_PRODUCTS_PLUGIN_PATH);

            add_action('admin_notices', array($this,'show_wpec_missing_notice'));

            return false;
        }

       return true;
   }

}


$wpecfp = new WPECFeaturedProducts();
//register_activation_hook( __FILE__, array($cfp, 'on_activate') );

